﻿var workflows = {
    context: $(".v-workflows"),
    datatable: null,
    initializeDataTable: function () {
        var contextMenuItems = [
            { "Action": "editWorkflow", "Label": resources.Properties },
            { "Action": "deleteWorkflow", "Label": resources.Delete }];

        var toolBarItems = [{ "Action": "delete", "Label": resources.Delete }];

        this.datatable = $(".h-workflowsTable", this.context).a4datatable({
            advancedFilter: true,
            ajaxAction: a4.getAction("GetWorkFlows", "MultiMode", "Settings"),
            ajaxParams: { "workflowId": 0 },
            columns: [
                { "Title": resources.Id, "Data": "Id", "Key": true, "Visible": false },
                { "Title": resources.WorkflowName, "Data": "Name" },
                { "Title": resources.NumberOfAssignment, "Data": "NumberOfInterviewerAssignment" },
                { "Title": resources.NumberOfInterviewerAssigned, "Data": "NumberOfInterviewerAssigned" },
                { "Title": resources.NumberOfInterviewerConnected, "Data": "NumberOfInterviewerConnected" },
                { "Title": resources.Projects, "Data": "Projects" },
                { "Title": resources.ModifiedOn, "Data": "ModifyDate", "Type": "datetime" }
            ],
            defaultSorting: "Name",
            allowRowSelection: true,
            stateKey: "ProjectsWorkflows",
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        workflows.deleteWorkflow(ids);
                        break;
                }
            },
            advancedFilter: true,
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "editWorkflow":
                        modalDialog.showWindow(a4.getAction("EditWorkflow", "MultiMode", "Settings", { workflowId: row.Id }), 600, 1000, { afterClose: function () { workflows.refreshContent(); } });
                        break;
                    case "deleteWorkflow":
                        workflows.deleteWorkflow([row.Id]);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchWorkflows }
        });
    },
    deleteWorkflow: function (workflowIds) {
        modalDialog.showConfirmDelete(confirmDeleteWorkflowResources, function () {
            a4.callServerMethod(a4.getAction("DeleteWorkflows", "MultiMode", "Settings"), { workflowIds: workflowIds },
                function (result) {
                    workflows.refreshContent();
                });
        }, workflowIds.length);
    },
    bindEvents: function () {
        workflows.context.on("click", ".h-newWorkflow", function () {
            modalDialog.showWindow(a4.getAction("EditWorkflow", "MultiMode", "Settings"), 600, 1000, { afterClose: function () { workflows.refreshContent(); } });
        });
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
};

$(document).ready(function () {
    if (workflows.context.length > 0) {

        workflows.initializeDataTable();
        workflows.bindEvents();
    }
});